function [mask_wwf, cmask_wwf, boundingBox_wwf, wwf_nan,wwf_fill_rough,wwf_fill] = segment_ROI_remove_headstamp(z_down)
% This function is used to remove the headstamp region frpm the cartridge
% case image/scan

%% input
% z_down -resampled z matrix  of the cartridge case image
%% output
% mask_wwf- mask image of ROI
% cmask_wwf- convex mask(binary) image of ROI
% boundingBox_wwf- bounding box of ROI
% wwf_nan- original values from z_down only in mask area with value 1 
% wwf_fill_rough- the original segmented ROI in perspective of whole image w/o any hole filing 
% wwf_fill- the original segmented ROI in perspective of whole image w hole filing 

% returns the bounding box, image and convex image of the ROI that excludes
% headstamp
me_z=nanmean(nanmean(z_down));
st_z=nanstd(nanstd(z_down));

[r c]=size(z_down);

bwz_whole=zeros(r,c);
bwz_whole1=zeros(r,c);
for i=1:r
    for j=1:c
        if z_down(i,j)>(me_z-st_z)
            bwz_whole(i,j)=1;
        end
        if z_down(i,j)>me_z
            bwz_whole1(i,j)=1;
        end
    end
end
a=bwconncomp(bwz_whole,8);
a_props=regionprops(a,'all');
area_z=cat(2,a_props(:).Area);

a1=bwconncomp(bwz_whole1,8);
a_props1=regionprops(a1,'all');
area_z1=cat(2,a_props1(:).Area);

[area_val area_in]=sort(area_z,'descend');

[area_val1 area_in1]=sort(area_z1,'descend');

mask_wwf=[];
cmask_wwf=[];
boundingBox_wwf=[];
if length(area_val)>1 & length(area_val1)>1
    % find 2nd indices with largest area
    ar=a_props(area_in(2)).Area;
    ar1=a_props1(area_in1(2)).Area;
    if ar >= ar1
        mask_wwf=a_props(area_in(2)).Image;
        cmask_wwf=a_props(area_in(2)).ConvexImage;
        boundingBox_wwf=a_props(area_in(2)).BoundingBox;
    else
        mask_wwf=a_props1(area_in1(2)).Image;
        cmask_wwf=a_props1(area_in1(2)).ConvexImage;
        boundingBox_wwf=a_props1(area_in1(2)).BoundingBox;
    end
    
elseif length(area_val)>1 & length(area_val1)==1
    mask_wwf=a_props(area_in(2)).Image;
    boundingBox_wwf=a_props(area_in(2)).BoundingBox;
    cmask_wwf=a_props(area_in(2)).ConvexImage;
    
elseif length(area_val)==1 & length(area_val1)>1
    mask_wwf=a_props1(area_in1(2)).Image;
    boundingBox_wwf=a_props1(area_in1(2)).BoundingBox;
    cmask_wwf=a_props1(area_in1(2)).ConvexImage;
    
else
    sprintf('ROI could not be extracted');
end
    
% Put the segmented region as a mask in original image (0 for other parts 1
% for segmented region

wwf_fill_rough=zeros(r,c);

% Use Bounding Box and PixelList to find area of interest with respect to
% the whole image
Xmin=boundingBox_wwf(1,1);
Ymin=boundingBox_wwf(1,2);
Width=boundingBox_wwf(1,3);
Height=boundingBox_wwf(1,4);

wwf_fill_rough(Ymin:Ymin+Height-1, Xmin:Xmin+Width-1)=mask_wwf;

wwf_fill=wwf_fill_rough;
wwf_fill(Ymin:Ymin+Height-1, Xmin:Xmin+Width-1)=cmask_wwf;
%Masked o/p

%% use output to get mask 1 regions from original image
Seg_BF_FP=z_down.*wwf_fill;

wwf_nan=Seg_BF_FP;
wwf_nan(wwf_nan==0)=NaN; % This is masked region in whole image

end

